//
//  ZoomServer.m
//  ZoomCocoa
//
//  Created by Andrew Hunter on Wed Sep 10 2003.
//  Copyright (c) 2003 Andrew Hunter. All rights reserved.
//

#import "ZoomServer.h"
#import "ZoomZMachine.h"

#include <sys/types.h>
#include <unistd.h>

NSAutoreleasePool* mainPool = nil;
NSRunLoop*         mainLoop = nil;

ZoomZMachine*      mainMachine = nil;

// == The main() function ==
int main(int argc, char** argv) {
    // Create the main autorelease pool and runloop
    mainPool = [[NSAutoreleasePool alloc] init];
    mainLoop = [NSRunLoop currentRunLoop];
	
    // Indicates that the client should be able to connect
    NSLog(@"Server ready");
	
	// Connect to the view process
	NSObject<ZClient>* client = nil;
	NSString* connectionName = [NSString stringWithFormat: @"Zoom-%s",
		argv[1]];

	NSConnection* remoteConnection = [NSConnection connectionWithRegisteredName: connectionName
																		   host: nil];
	
	if (remoteConnection == nil) {
		NSLog(@"Warning: unable to locate connection %@. Aborting.", connectionName);
	}
	
	client = (NSObject<ZClient>*)[remoteConnection rootProxy];
	[client retain];
	
	if (client == nil) {
		NSLog(@"Unable to locate client object for connection %@. Aborting", connectionName);
		abort();
	}
	
	mainMachine = [[ZoomZMachine alloc] init];
	if ([client connectToDisplay: mainMachine] == nil) {
		NSLog(@"Failed to connect to view");
		abort();
	}
	
	[[NSNotificationCenter defaultCenter] addObserver: mainMachine
											 selector: @selector(connectionDied:)
												 name: NSConnectionDidDieNotification
											   object: remoteConnection];
	
	NSLog(@"Server connected");

	// Main runloop
	while (mainMachine != nil) {
		[mainPool release];
		mainPool = [[NSAutoreleasePool alloc] init];
        
        [mainLoop acceptInputForMode: NSDefaultRunLoopMode
                          beforeDate: [NSDate distantFuture]];
	}

#ifdef DEBUG
    NSLog(@"Finalising...");
#endif
    [mainPool release];
    
    return 0;
}
